/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Feb 27 00:46:12 2008 by Jeff Dalton
 * Copyright: (c) 2008, AIAI, University of Edinburgh
 */

package ix.icore.log;

import java.io.*;
import java.util.*;

import ix.util.*;
import ix.util.xml.*;

/**
 * Utility for reading logs of HistoryEvents.
 */
public class EventLogReader {

    public EventLogReader() {
    }

    public List<HistoryEvent> readLog(String logFileName) {
	try {
	    return do_readLog(logFileName);
	}
	catch (IOException io_e) {
	    throw new RethrownIOException(io_e);
	}
    }

    protected List<HistoryEvent> do_readLog(String logFileName)
              throws IOException {
	InputStream stream = new FileInputStream(logFileName);
	Reader streamReader = new InputStreamReader(stream, "UTF-8");
	BufferedReader in = new BufferedReader(streamReader);
	List<HistoryEvent> events = new LinkedList<HistoryEvent>();
	while (true) {
	    String block = readBlock(in);
	    if (block == null)
		break;
	    block = block.trim();
	    if (block.equals(""))
		continue;
	    HistoryEvent event = (HistoryEvent)XML.objectFromXML(block);
	    events.add(event);
	}
	return events;
    }

    protected String readBlock(BufferedReader in) {
	String line = readLine(in);
	if (line == null)
	    return null;
	StringBuffer result = new StringBuffer();
	while (true) {
	    result.append(line);
	    result.append("\n");
	    line = readLine(in);
	    if (line == null)
		break;
	    if (line.startsWith("</")) {
		result.append(line);
		result.append("\n");
		break;
	    }
	}
	return result.toString();
    }

    protected String readLine(BufferedReader in) {
	try {
	    return in.readLine();
	}
	catch (IOException e) {
	    Debug.displayException(e);
	    return null;
	}
    }

}

// Issues:
// * Should be a general utility for reading more than one top-level
//   XML entity from files, etc.
