/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu May 29 18:06:46 2008 by Jeff Dalton
 * Copyright: (c) 2002, 2003, 2008, AIAI, University of Edinburgh
 */

package ix.icore.domain;

import java.io.Serializable;
import java.util.*;

import ix.util.*;
import ix.util.lisp.*;

/**
 * A probably temporary representation of temporal "before" constraints.
 */
public class Ordering extends Constrainer 
                      implements NodeEndRange, Serializable {

    protected NodeEndRef from;
    protected NodeEndRef to;

    public Ordering() {
    }

    public Ordering(NodeEndRef from, NodeEndRef to) {
	super();
	this.from = from;
	this.to = to;
    }

    public NodeEndRef getFrom() { return from; }

    public void setFrom(NodeEndRef from) { this.from = from; }

    public NodeEndRef getTo() { return to; }

    public void setTo(NodeEndRef to) { this.to = to; }

    public boolean equals(Object obj) {
	if (obj instanceof Ordering) {
	    Ordering ord = (Ordering)obj;
	    return from.equals(ord.from) && to.equals(ord.to);
	}
	else return false;
    }

    public int hashCode() {
	return 31 * from.hashCode() + to.hashCode();
    }

    public String toString() {
	return "Ordering[" + from + " --> " + to + "]";
    }

    /*
     * Look more like a Constraint
     */

    //\/ Relation is "ordering" so that we don't look too much
    //   like a "before" Constraint.

    public static final Symbol
	S_TEMPORAL = Symbol.intern("temporal"),
	S_ORDERING   = Symbol.intern("ordering");

    public Symbol getType() { return S_TEMPORAL; }

    public Symbol getRelation() { return S_ORDERING; }

    public List getParameters() { return Collections.emptyList(); }

}
