/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Nov 10 20:45:33 2004 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.icore.domain;

import java.io.Serializable;
import java.util.*;

import ix.util.*;
import ix.util.lisp.*;
import ix.util.match.MatchEnv;

public class NodeSpec implements Serializable {

    protected Name id;
    protected LList pattern;

    public NodeSpec() {
    }

    public NodeSpec(Name id, LList pattern) {
	this.id = id;
	this.pattern = pattern;
    }

    public NodeSpec(Object id, LList pattern) {
	this.id = Name.valueOf(id);
	this.pattern = pattern;
    }

    public NodeSpec(int id, LList pattern) {
	this(new Integer(id), pattern);
    }

    public Name getId() { return id; }
    public void setId(Name id) { this.id = id; }

    public LList getPattern() { return pattern; }
    public void setPattern(LList pattern) { this.pattern = pattern; }

    public NodeSpec instantiate(MatchEnv env, Function1 ifUnbound) {
	LList ipat = (LList)env.instantiateTree(pattern, ifUnbound);
	return new NodeSpec(id, ipat);
    }

    public String toString() {
	return "NodeSpec[" + id + " " + pattern + "]";
    }

}

// Issues:
// * What we call an id here is called a name in a NodeEndRef.

