/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Aug  6 16:14:09 2008 by Jeff Dalton
 * Copyright: (c) 2008, AIAI, University of Edinburgh
 */

package ix.icore.domain;

import ix.util.*;

/**
 * Represents the range covered by a constraint, 'from' one node-end
 * 'to' another.  The 'from' end can be null, and the subclass
 * {@link AtNodeEnd} is often used in that case.
 */
public class ConstraintRange implements NodeEndRange, Cloneable {

    protected NodeEndRef from;
    protected NodeEndRef to;

    public ConstraintRange() {
    }

    public ConstraintRange(NodeEndRef from, NodeEndRef to) {
	super();
	this.from = from;
	this.to = to;
    }

    public NodeEndRef getFrom() {
	return from;
    }

    public void setFrom(NodeEndRef from) {
	this.from = from;
    }

    public NodeEndRef getTo() {
	return to;
    }
    
    public void setTo(NodeEndRef to) {
	this.to = to;
    }

    public boolean equals(Object obj) {
	if (obj instanceof ConstraintRange) {
	    ConstraintRange r = (ConstraintRange)obj;
	    return from.equals(r.from) && to.equals(r.to);
	}
	else return false;
    }

    public int hashCode() {
	return 31 * from.hashCode() + to.hashCode();
    }

    public ConstraintRange clone() throws CloneNotSupportedException {
	return (ConstraintRange)super.clone();
    }

    public String toString() {
	return "ConstraintRange[" + from + " --> " + to + "]";
    }

}
