/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed May 28 17:31:01 2008 by Jeff Dalton
 * Copyright: (c) 2003, 2008, AIAI, University of Edinburgh
 */

package ix.icore.domain;

import java.util.List;

import ix.icore.AbstractIXObject;

import ix.util.lisp.Symbol;

/**
 * A common superclass for {@link Constraint} and {@link Ordering}.
 * This is a temporary expedient for use until a proper constraint
 * framework has been developed.
 */
public abstract class Constrainer extends AbstractIXObject {

    public Constrainer() {
    }

    public abstract Symbol getType();

    public abstract Symbol getRelation();

    public abstract List getParameters();

}

// Issues:
// * A nicer name might be "Restriction".
