/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Aug  6 16:28:07 2008 by Jeff Dalton
 * Copyright: (c) 2008, AIAI, University of Edinburgh
 */

package ix.icore.domain;

import ix.util.*;
import ix.util.reflect.AliasFields;
import ix.util.reflect.HiddenFields;

/**
 * A constraint-range that should be used when the constraint applies
 * 'at' at a node-end rather than across a range.  When looked at as
 * a {@link ConstraintRange}, the 'at' end will appear as the range's
 * 'to' end, and the range's 'from' end will be null.
 */
@AliasFields({"to->at"})
@HiddenFields({"from"})
public class AtNodeEnd extends ConstraintRange {

    public AtNodeEnd() {
    }

    public AtNodeEnd(NodeEndRef at) {
	super();
	setAt(at);
    }

    public NodeEndRef getAt() {
	return to;
    }

    public void setAt(NodeEndRef at) {
	setFrom(null);
	setTo(at);
    }

    @Override
    public String toString() {
	return "AtNodeEnd[" + getAt() + "]";
    }

}
