/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Feb 14 00:02:59 2002 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.icore;

import java.util.*;
import ix.util.*;

/**
 * YesNo values.
 */
public final class YesNo extends EnumeratedValue {

    private static List values = new LinkedList();

    private YesNo() { }

    private YesNo(String name) {
	this.name = name;
	recordValue(values, this);
    }	

    public static final YesNo
	YES = new YesNo("yes"),
	NO  = new YesNo("no");

    public String toString() {
	return name;
    }

    public static List values() {
	return Collections.unmodifiableList(values);
    }

    public static YesNo valueOf(String name) {
	return (YesNo)getValueElseError(values, name);
    }

    public static YesNo valueOf(boolean v) {
	return v ? YES : NO;
    }

}


