/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Aug 17 20:50:58 2002 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.icore;

import java.util.*;
import ix.util.*;

/**
 * Report types.
 */
public final class ReportType extends EnumeratedValue {

    private static List values = new LinkedList();

    private ReportType() { }

    private ReportType(String name) {
	this.name = name;
	recordValue(values, this);
    }	

    public static final ReportType
	SUCCESS     = new ReportType("success"),
	FAILURE     = new ReportType("failure"),
	PROGRESS    = new ReportType("progress"),
	INFORMATION = new ReportType("information"),
	EVENT       = new ReportType("event");

    public String toString() {
	return name;
    }

    public static List values() {
	return Collections.unmodifiableList(values);
    }

    public static ReportType valueOf(String name) {
	return (ReportType)getValueElseError(values, name);
    }

}


