/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Sep 12 14:01:46 2003 by Jeff Dalton
 * Copyright: (c) 2001, 2002, AIAI, University of Edinburgh
 */

package ix.icore;

import java.util.*;
import java.io.Serializable;

import ix.util.*;
import ix.icore.domain.Constraint;

import ix.util.lisp.Symbol;	//\/ for attached constraints
import ix.icore.domain.LinkedListOfConstraint;

/**
 * A report sent from another agent.
 */
public class Report extends AbstractIXObject
    implements Serializable, Cloneable, Sendable {

    protected String text;
    protected ReportType reportType;
    protected Priority priority = Priority.NORMAL;
    protected Name senderId;
    protected Name ref;

    public Report() {
    }

    public Report(String text) {
	this.text = text;
    }

    public Report(ReportType type, String text) {
	this.reportType = type;
	this.text = text;
    }

    public String getText() {
	return text;
    }

    public void setText(String text) {
	this.text = text;
    }

    public ReportType getReportType() {
	ReportType type = reportType;
	if (type != null)
	    return type;

	String text = getText().trim().toLowerCase();
	Debug.noteln("Setting report-type from report text", Util.quote(text));
	if (!text.startsWith("done"))
	    type = ReportType.PROGRESS;
	else if (text.indexOf("no solutions") > -1)
	    type = ReportType.FAILURE;
	else if (text.indexOf("failure") > -1) // is this used? /\/
	    type = ReportType.FAILURE;
	else
	    type = ReportType.SUCCESS;

	setReportType(type);
	return type;
    }

    public void setReportType(ReportType type) {
	this.reportType = type;
    }

    public Priority getPriority() {
	return priority;
    }

    public void setPriority(Priority priority) {
	this.priority = priority;
    }

    public Name getSenderId() {
	return senderId;
    }

    public void setSenderId(Name id) {
	this.senderId = id;
    }

    public Name getRef() {
	return ref;
    }

    public void setRef(Name ref) {
	this.ref = ref;
    }

    public boolean isCompletion() {
	// It's not clear what the rules really are.  /\/
	// return !getReportType().equals("progress");
	return getReportType() == ReportType.SUCCESS
	    || getReportType() == ReportType.FAILURE;
    }

    public boolean isSuccess() {
	return getReportType() == ReportType.SUCCESS;
    }

    public boolean isFailure() {
	return getReportType() == ReportType.FAILURE;
    }

    public boolean isProgress() {
	return getReportType() == ReportType.PROGRESS;
    }

    // Attached constraints

    private static final Symbol S_CONSTRAINTS = Symbol.intern("constraints");

    public List getConstraints() {
	return (List)getAnnotation(S_CONSTRAINTS);
    }

    public void setConstraints(List cons) {
	setAnnotation(S_CONSTRAINTS, cons);
    }

    public void addConstraint(Constraint c) {
	if (getConstraints() == null)
	    setConstraints(new LinkedListOfConstraint());
	getConstraints().add(c);
    }

    // /\/: Other report types don't (yet?) have is-methods here.

    public Object clone() throws CloneNotSupportedException {
	return super.clone();
    }

    public String toString() {
	return "report[" + text + "]";
    }

}
