/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Sep 21 23:48:13 2004 by Jeff Dalton
 * Copyright: (c) 2001, 2004, AIAI, University of Edinburgh
 */

package ix.icore;

import java.util.*;

import ix.icore.event.AnnotationListener;
import ix.util.*;

/**
 * Objects that have annotations.
 */
public interface Annotated {

    public Annotations getAnnotations();

    public void setAnnotations(Annotations annotations);

    public Object getAnnotation(Object key);

    public void setAnnotation(Object key, Object value);

    public void removeAnnotation(Object key);

    public void clearAnnotations();

    public void takeAnnotations(Map map);

    public void addAnnotationListener(AnnotationListener listener);

    public void fireSetAnnotation(Object key, Object value);

}
