/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Mar  6 16:57:40 2010 by Jeff Dalton
 * Copyright: (c) 2001, 2002, 2006, 2009, 2010, AIAI, University of Edinburgh
 */

package ix.ichat;

import java.io.Serializable;
import java.util.*;

import ix.icore.Sendable;
import ix.icore.AbstractAnnotatedObject;
import ix.util.*;
import ix.util.lisp.*;

/**
 * An object to send when conducting chat dialogues.
 */
public class ChatMessage extends AbstractAnnotatedObject
                         implements Serializable, Cloneable, Sendable {

    // /\/: Should we extend AbstractIXObject instead?

    protected String text;
    protected Name senderId;

    public ChatMessage() {
    }

    public ChatMessage(String text, String senderId) {
	this.text = text;
	this.senderId = Name.valueOf(senderId);
    }

    public String getText() {
	return text;
    }

    public void setText(String text) {
	this.text = text;
    }

    public Name getSenderId() {
	return senderId;
    }

    public void setSenderId(Name id) {
	this.senderId = id;
    }

    public Object clone() throws CloneNotSupportedException {
	return super.clone();
    }

    public String toString() {
        return "ChatMessage["
            + (text.length() < 10 ? text : text.substring(0,10) + " ...")
            + "]";
    }

}
