/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Mar 19 20:20:08 2005 by Jeff Dalton
 * Copyright: (c) 2000, 2005, AIAI, University of Edinburgh
 */

package ix.examples;

import java.util.*;

import ix.util.*;
import ix.util.lisp.*;


/**
 * A simple example using an I-X framework.  This example shows how
 * to define and use new Controller and ActivityHandler subclasses.<p>
 *
 * It also shows how to use PicoIX by defining a PicoIX subclass
 * that contains the application.
 */

public class PicoIXTest2 extends PicoIX {

    /**
     * Main program.
     */
    public static void main(String[] argv) {

	IX_System example = new IX_System(new TestController(), null);

	example.addActivityHandlers(makeTestActivityHandlers());
	example.setListener(new IX_SystemListener());
	example.start();

	example.newEvent
	    (new Activity("twice", new Activity("return", "hello")));

	example.newEvent
	    (new Activity("stop"));

    }

    /**
     * A Controller that supports pushActivity().
     */
    static class TestController extends Controller {

	TestController() {}

	protected void pushActivity(Activity i) { 	// move to subclass /\/
	    Debug.noteln("Pushing", i);
	    activities.pushElement(i);
	}

    }

    /**
     * ActivityHandlers that can use pushActivity().
     */
    static abstract class TestActivityHandler extends ActivityHandler {

	TestActivityHandler(Object verb) {
	    super(verb);
	}

	void pushActivity(Activity i) {
	    ((TestController)system.controller).pushActivity(i);
	}

    }

    /**
     * Create activity handlers as "instant" subclasses of TestActivityHandler.
     */
    static Object[] makeTestActivityHandlers() {
	return new Object[] {

	    // Post an activity twice.
	    new TestActivityHandler("twice") {
		void handleActivity(Activity i) {
		    pushActivity((Activity)i.object);
		    pushActivity((Activity)i.object);
		}
	    },

            // Send something to the listener.
	    new TestActivityHandler("return") {
		void handleActivity(Activity i) {
		    system.notifyListener(i.object);
		}
	    },

	    // Stop the system.
	    new TestActivityHandler("stop") {
		void handleActivity(Activity i) {
		    system.stop();
		}
	    }
	};
    }

}
