/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Aug 23 14:48:17 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.applet;

import java.util.*;

import ix.util.*;

public class MessageMemory {

    SortedMap seqNoToMessageMap = new TreeMap();

    public MessageMemory() { }

    public int size() {
	return seqNoToMessageMap.size();
    }

    public void remember(AppletMessage m) {
	Integer i = m.getSequenceNumber();
	Debug.expect(!seqNoToMessageMap.containsKey(i));
	seqNoToMessageMap.put(i, m);
    }

    public void forget(AppletMessage m) {
	forgetKey(m.getSequenceNumber());
    }

    public void forgetKey(Integer key) {
	Debug.expect(seqNoToMessageMap.containsKey(key));
	seqNoToMessageMap.remove(key);
    }

    public boolean containsKey(Object key) {
	return seqNoToMessageMap.containsKey(key);
    }

    public Object firstKey() {
	return seqNoToMessageMap.firstKey();
    }

    public Object lastKey() {
	return seqNoToMessageMap.lastKey();
    }

    public AppletMessage getFirstRemainingMessage() {
	return seqNoToMessageMap.isEmpty()
	    ? null
	    : (AppletMessage)seqNoToMessageMap
	          .get(seqNoToMessageMap.firstKey());
    }

    public void walkContents(Proc p) {
	for (Iterator i = seqNoToMessageMap.entrySet().iterator();
	     i.hasNext();) {
	    Map.Entry e = (Map.Entry)i.next();
	    p.call(e.getKey(), e.getValue());
	}
    }

}
