/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Oct  1 02:00:13 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.util.rdf;

import java.util.*;

import ix.util.*;

/**
 * Thinks it knows the singular form of plurals.
 */
class Morphology {

    Morphology() {
    }

    String singular(String plural) {
	if (plural.length() > 4 && plural.endsWith("ies"))
	    return Strings.beforeLast("ies", plural) + "y";
	else if (plural.endsWith("xes"))
	    return Strings.beforeLast("es", plural);
	else if (plural.endsWith("s"))
	    return Strings.beforeLast("s", plural);
	else
//  	    throw new IllegalArgumentException
//  		("Don't know the singular of " + Strings.quote(plural));
//  	    Debug.noteln("Don't know the singular of " + plural +
//  			 ", assuming " + plural);
	    return plural;
    }

    protected void test(String plural, String expectedSingular) {
	String sing = singular(plural);
	if (!sing.equals(expectedSingular))
	    Debug.noteln(plural + " --> " + sing +
			 ", s.b. " + expectedSingular);
    }

    public static void main(String[] argv) {
	Morphology m = new Morphology();
	m.test("apples", "apple");
	m.test("pies", "pie");
	m.test("ties", "tie");
	m.test("tries", "try");
	m.test("babies", "baby");
	m.test("magpies", "magpie"); 		// /\/
	m.test("neckties", "necktie");		// /\/
	m.test("empties", "empty");
	m.test("entries", "entry");
	m.test("activities", "activity");
	m.test("bees", "bee");
	m.test("foxes", "fox");
	m.test("oxen", "ox");			// /\/
	m.test("faxes", "fax");
	m.test("deer", "deer");
	m.test("waters", "water");
	m.test("mice", "mouse");		// /\/
	m.test("data", "datum"); 		// /\/
	m.test("media", "medium"); 		// /\/
    }

}
