/****************************************************************************
 * A ComboBox that contains items that represent priorities.
 *
 * @author Jussi Stader
 * @version 1.0
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.iview.util;

import javax.swing.JComboBox;

import java.util.*;

import ix.icore.Priority;
import ix.iface.ui.*;
import ix.util.*;

/**
 * A ComboBox that contains items that represent priorities.
 * "Normal" is initially selected.
 *
 * @see ix.icore.Priority
 */
public class PriorityComboBox extends IXComboBox {

  public PriorityComboBox() {
    super();
    setEditable(false);
    PriorityRenderer r = new PriorityRenderer(false);
    r.setLined(true);
    setRenderer(r);
    // The values are lowest-first, so we reverse them.
    List values = new ArrayList(Priority.values());
    Collections.reverse(values);
    for (Iterator i = values.iterator(); i.hasNext();) {
      Priority p = (Priority)i.next();
      addItem(p);
    }
    setSelectedItem(Priority.NORMAL);
    //this should not be necessary, but it seems to be needed
    //setBackground(Priority.NORMAL.getColor());
  }

  public Priority getSelectedPriority() {
    try { return (Priority)getSelectedItem(); }
    catch (ClassCastException cce) {
      return ((EditablePriority)getSelectedItem()).priority;
    }
  }

  public void setPriority(Priority priority) {
    setSelectedItem(priority);
  }
  public void setPriority(EditablePriority priority) {
    setSelectedItem(priority.priority);
  }

}


