/**************************************************************************
 * Maintains notes of modelling issues and state of development
 *
 * @author: Jussi Stader <J.Stader@ed.ac.uk>
 * @version: 3.1
 * Updated: Thu Nov 30 09:59:32 2006
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 **************************************************************************
 */

package ix.iview.util;

import java.util.*;

import ix.util.*;
import ix.util.lisp.*;
import ix.icore.domain.*;

/**************************************************************************
 * A class to maintain notes of modelling issues and state of modelling 
 * progress.
 * KADS state values:
 *  empty (initial value, no work done yet)
 *  identified (basic editing done)
 *  described (first draft - modelling done)
 *  validated (test, verify, validate; internal and external)
 *  completed (accepted and signed off) 
 *
 **************************************************************************
 */
//NOTE: also: viewing state - anything there that is not shown?
//e.g. minimised fields, something the viewer is not suitable for(graphics, 
// ), ...

public class ModellingState {
  public final static Symbol MS_DEFAULT = Symbol.intern("default");
  public final static Symbol MS_EMPTY = Symbol.intern("empty");
  public final static Symbol MS_CONSISTENT = Symbol.intern("consistent");
  public final static Symbol MS_DONE = Symbol.intern("done");

  protected Symbol state = MS_DEFAULT;
  //a set of notes that can be shown (one per line)
  protected LinkedList notes = new LinkedList();
  //a set of labels/markers; these should be shown as symbols/colours
  protected LinkedList labels = new LinkedList();
  

  public ModellingState() {
    super();
  }

  public void setState(String state) {
    if ((state == null) || state.equals("")) this.state = null;
    else setState(Symbol.intern(state));
  }
  public void setState(Symbol state) {
    if ((state == null) || state.equals(MS_DEFAULT) || 
	state.equals(MS_EMPTY) || state.equals(MS_CONSISTENT) || 
	state.equals(MS_DONE)) 
      this.state = state;
    else Debug.noteln("IDE-MS: cannot set modelling state to", state);
  }
  public Symbol getState() { return state;}

  public void setNotes(String note) {
    notes.clear();
    notes.add(note);
  }
  public void addNote(String note) {
    notes.add(note);    
  }

}

// Issues:


