/****************************************************************************
 * Static utilities for IDE things
 *
 * @author Jussi Stader
 * @version 2.0
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.iview.util;

import ix.iface.ui.util.*;
import ix.icore.*;
import ix.icore.domain.*;
import ix.iview.IDESymbols;
import ix.iview.domain.*;
import ix.util.*;
import ix.util.lisp.*;
import java.lang.reflect.*;
import java.util.*;
import java.net.URL;
import javax.swing.*;
import java.awt.Component;
import java.awt.event.*;


/** Class for useful static methods for IDE. */

public class IDEUtil implements IDESymbols {

  public static Symbol constPrefToSymbol(String pref) {
    return Symbol.valueOf(pref);
  }
  public static Symbol constPrefToSymbol(int pref) {
    if (pref == 1) return C_ORDER_ONLY;
    else if (pref == 10) return C_CONDITIONS_ONLY;
    else if (pref == 11) return C_ORDER_CONDITIONS;
    else if (pref == 100) return C_OTHER_ONLY;
    else if (pref == 101) return C_ORDER_OTHER;
    else if (pref == 110) return C_CONDITIONS_OTHER;
    else if (pref == 111) return C_ALL;
    else return C_NONE;
  }
  public static String constPrefToString(int pref) {
    return constPrefToSymbol(pref).toString();
  }
  public static int constPrefToInt(Symbol pref) {
    if (pref == C_NONE) return 0;
    else if (pref == C_ORDER_ONLY) return 1;
    else if (pref == C_CONDITIONS_ONLY) return 10;
    else if (pref == C_ORDER_CONDITIONS) return 11;
    else if (pref == C_OTHER_ONLY) return 100;
    else if (pref == C_ORDER_OTHER) return 101;
    else if (pref == C_CONDITIONS_OTHER) return 110;
    else return 111;
    
  }
  public static int makeConstPrefInt(boolean order, boolean condEff, 
				     boolean other) {
    int pref = 0;
    if (order) pref = pref + 1;
    if (condEff) pref = pref + 10;
    if (other) pref = pref + 100;
    return pref;
  }
  public static Symbol makeConstPrefSymbol(boolean order, boolean condEff, 
					   boolean other) {
    //Debug.note("IDEUtil: making constraint view from ");
    //Debug.note(new Boolean(order).toString());
    //Debug.noteln(new Boolean(condEff).toString(), new Boolean(other));

    int pref = makeConstPrefInt(order, condEff, other);
    //Debug.noteln(" int is", pref);
    return constPrefToSymbol(pref);
  }
  public static boolean showOrder(int pref) {
    return (1 == (pref % 10));
  }
  public static boolean showOther(int pref) {
    return (pref >= 100);
  }
  public static boolean showConditions(int pref) {
    return ((pref % 100) >= 10);
  }
  public static boolean showOrder(Symbol preference) {
    return showOrder(constPrefToInt(preference));
  }
  public static boolean showOther(Symbol preference) {
    return showOther(constPrefToInt(preference));
  }
  public static boolean showConditions(Symbol preference) {
    return showConditions(constPrefToInt(preference));
  }


  public static boolean showConstraints(String which, String pref) {
    return showConstraints(which, constPrefToSymbol(pref));
  }
  public static boolean showConstraints(String which, Symbol pref) {
    return showConstraints(which, constPrefToInt(pref));
  }
  public static boolean showConstraints(String which, int pref) {
    if (which.equals("order") || which.equals("orderings")) 
      return showOrder(pref);
    if (which.equals("conditions") || which.equals("conditions/effects")) 
      return showConditions(pref);
    if (which.equals("other") || which.equals("other constraints")) 
      return showOther(pref);
    else return false;
  }

}
