/****************************************************************************
 * A Renderer for Actions
 *
 * @author Jussi Stader
 * @version 3.1
 * Updated: Thu Nov  9 11:48:44 2006
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview.util;

import java.util.*;

import ix.iface.ui.*;
import ix.iview.domain.*;
import ix.util.Debug;
import ix.util.lisp.LList;
import ix.icore.domain.*;

public class ActionListRenderer extends IXLabelRenderer { //IXTextRenderer
    public ActionListRenderer(boolean b) {super(b);}

    public void setInfo(Object object){
      if (object == null) setText("");
      else {
	String name;
	LList pattern;
	if (object instanceof Refinement) {
	  Refinement r = (Refinement)object;
	  String text = makeText(r.getName(), r.getPattern());
	  setText(text);
	}
	else if (object instanceof UIRefinement) {
	  UIRefinement r = (UIRefinement)object;
	  String text = makeText(r.getName(), r.getPattern());
	  setText(text);
	}
	else if (object instanceof NodeSpec) {
	  NodeSpec n = (NodeSpec)object;
	  String text = makeText(n.getId().toString(), n.getPattern());
	  setText(text);
	}
	else {
	  Debug.noteln("Can only render refinements in global form panels");
	}
      }
    }

    private String makeText(String name, List pattern) {
      String text = "";
      for (Iterator i = pattern.iterator(); i.hasNext();) {
	text = text + i.next().toString() + " ";
      }
      text = name + " (" + text + ")";
      return text;
    }

}


