/****************************************************************************
 * A TreeModel that can display domain components (Refinement and ObjectClass).
 *
 * @author Jussi Stader
 * @version 2.0
 * Updated: Thu Sep 28 10:26:06 2006
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.iview.tree;

import java.util.*;
import javax.swing.*;
import javax.swing.tree.*;

import ix.util.*;
import ix.util.lisp.*;
import ix.icore.domain.*;
import ix.icore.domain.event.*;
import ix.icore.*;
import ix.iview.domain.*;
import ix.iview.domain.event.*;
import ix.iface.ui.tree.*;


public abstract class DomainTreeModel extends EditableTreeModel
  implements UIDomainListener
{

  UIDomain uiDomain;
    

  /**
   * Constructs a new instance with the given node as the root node
   * of the tree.
   * @param domain The UIDomain for this model.
   * @param root The root node of the tree model.  
   */
  public DomainTreeModel(UIDomain domain, IXTreeNode root) {
    super(root);
    this.uiDomain = domain;
    uiDomain.addUIDomainListener(this);
  }
  /**
   * Constructs a new instance with a default root node
   * of the tree.
   * @param domain The UIDomain for this model.
   * @param root The root node of the tree model.  
   * @param domainObjects The objects that are to appear in the tree
   * @param map the tree node map.
   */
  public DomainTreeModel(UIDomain domain, IXTreeNode root, 
			 HashSet domainObjects, HashMap nodeMap) {
    super(root, domainObjects, nodeMap);
    this.uiDomain = domain;
    uiDomain.addUIDomainListener(this);
  } 

  //make sure domain knows
  public IXTreeNode newTreeChild(IXTreeNode parent) {
    IXTreeNode newChild = super.newTreeChild(parent);
    uiDomain.addConstruct((UIObject)newChild.getUserObject());
    return newChild;
  }

  public UIDomain getUIDomain() {
    return uiDomain;
  }
 	
  //----------------------UIDomainListener things---------------------------

  public void constructAdded(DomainEvent event) {
    Debug.noteln("DomTreeM: construct added to domain - nothing done");
  }
  public void constructAdded(UIDomainEvent event) {
    //Debug.noteln("DomTreeM: construct added to domain", event.getObject());
    if (isOwnUserObject(event.getObject())) {
      //Debug.noteln("DomTreeM: construct added to domain");
      userNodeAdded(event.getObject(), event);
    }
  }

  public void constructEdited(UIDomainEvent event) {
    if (isOwnUserObject(event.getObject())) {
      //Debug.noteln("DomTreeM: construct edited to domain", event);
      userNodeChanged(event);
    }
  }
  public void constructRemoved(UIDomainEvent event) {
    if (isOwnUserObject(event.getObject())) {
      //Debug.noteln("DomTreeM: construct removed to domain");
      userNodeRemoved(event.getObject());
    }
  }
  public void domainCleared(UIDomainEvent event) {
    reloadData();
  }
  public void domainEdited(UIDomainEvent event) {
    reloadData();
  }
  public void domainSet(UIDomainEvent event) {
    reloadData();
  }



  /** Creates a new instance of a suitable IXTreeNode from the user object */
  public abstract IXTreeNode newIXTreeNode(Object userNode);


  public abstract List findUserObjects();
  public abstract Object makeUserObject(String name);
  public abstract Object makeUserObject(String name, List children);
  /*
  public abstract Object makeUserObject(String name, Object parent, 
					List children);
  */

  public abstract List getUserChildren(Object userParent);
  public abstract void addUserChild(Object userParent, Object newChild);
  public abstract void removeUserChild(Object userParent, Object newChild);


}
