package ix.iview.igraph;

import ix.util.*;
import ix.util.xml.XML;

public class NodePosition {

    Name name;
    double x;
    double y;

    public NodePosition() { }

    public NodePosition(Name name, double x, double y) {
	this.name = name;
	this.x = x;
	this.y = y;
    }

    public Name getName() { return name; }
    public void setName(Name name) { this.name = name; }

    public double getX() { return x; }
    public void setX(double x) { this.x = x; }

    public double getY() { return y; }
    public void setY(double y) { this.y = y; }

  public boolean equals(NodePosition other) {
    //Debug.noteln("checking", this);
    //Debug.noteln(" against", other);
    return (this.getName().equals(other.getName()) &&
	    (this.getX() == other.getX()) &&
	    (this.getY() == other.getY()));
  }
  public boolean equals(Object other) {
    try {
      return equals((NodePosition) other);
    }
    catch (Exception e) {return false;}
  }

  public String toString() {
    return name + "(" + x + ", " + y + ")";
  }

    public static void main(String[] argv) {
	NodePosition p = new NodePosition(Name.valueOf("node-1"),
					  100.1, 200.0);
	Debug.noteln("Example:",
		     XML.objectToXMLString(p));
    }

}
