package ix.iview.igraph;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import lt.monarch.graph.*;
import lt.monarch.graph.view.*;
import lt.monarch.graph.view.looks.*;
import lt.monarch.graph.view.layouts.*;
import lt.monarch.graph.plugins.*;
import lt.monarch.graph.swing.*;


public class CompositeRectangularNode extends RectangularNode {
  JLabel label;
  JLabel top;
  JLabel bottom;
  public CompositeRectangularNode(GraphView  graphView, 
				  GraphPanel graphPanel, Object node) {
    super(graphView, node);
    JComponentBlock body = new JComponentBlock(graphPanel);
    body.setParent(this);
    JPanel contentPanel = body.getContentPane();
    contentPanel.setLayout(new BorderLayout());
    setBackground(contentPanel.getBackground());
    label = new JLabel("", JLabel.CENTER);
    top = new JLabel("", JLabel.LEFT);
    bottom = new JLabel("", JLabel.RIGHT);
    contentPanel.add(label,BorderLayout.CENTER);
    contentPanel.add(top,BorderLayout.NORTH);
    contentPanel.add(bottom,BorderLayout.SOUTH);
    setBody(body);
  }

  public void setTop(String s) {
    //top.setText("<html><font size=-1>" + s + "</font></html>");
    top.setText(s);
  }
  public void setBottom(String s) {
    //bottom.setText("<html><font size=-1>" + s + "</font></html>");
    bottom.setText(s);
  }
  public void setLabel(String s) {
    label.setText(s);
  }
}
