/****************************************************************************
 * An interface for things that are interested in changes to which construct
 * is being edited.
 *
 * @author Jussi Stader
 * @version 3.1
 * Updated: Mon Oct 24 14:19:33 2005
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview.event;

import java.awt.Component;
import ix.iview.domain.UIObject;
import ix.iview.ConstructFraming;

/****************************************************************************
 * An interface for things that are interested in changes to which construct
 * is being edited.
 *****************************************************************************
 */
public interface CurrentConstructListener {
  /**
   * Implement this method to take note of action selections
   * @param source the component that changed the action
   * @param newAction the new action
   */
  public void constructChanged(Component source, 
			       UIObject oldUIO, UIObject newUIO);
}
