/****************************************************************************
 * An interface for things that are interested in current action selection
 *
 * @author Jussi Stader
 * @version 1.0
 * Updated: Mon Sep 11 14:59:55 2006
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview.event;

import ix.iview.domain.*;
import java.awt.Component;

/****************************************************************************
 * An interface for things that are interested in current action selection
 *****************************************************************************
 */
public interface CurrentActionListener {
  /**
   * Implement this method to take note of action selections
   * @param source the component that changed the action
   * @param oldAction the previous action
   * @param newAction the new action
   */
  public void actionChanged(Component source, 
			    UIRefinement oldAction, UIRefinement newAction);
}
