/****************************************************************************
 * An interface to be implemented by any panel that actually edits a construct.
 *
 * @author Jussi Stader
 * @version 3.1
 * Updated: Wed Oct  5 10:46:34 2005
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *****************************************************************************
 */
package ix.iview;

import ix.icore.*;
import ix.iview.domain.*;
import ix.iface.ui.EditableObject;

/****************************************************************************
 * An interface to be implemented by any panel that edits a construct
 * and wants to take advantage of an UndoManager.  Current Examples are
 * IFormPanels.
 *****************************************************************************
 */
public interface UndoEditing 
{
  
  /** Sets the given field to the given value in the editor. */
  public void undoSetValue(String field, Object value);
  /** Gets the given field to the given value in the editor. */
  public Object undoGetValue(String field);

}

/*Issues***************************************************************
 */
/*Todos***************************************************************
 *****************************************************************************
 */
