/****************************************************************************
 * Support for editing sets of named objects (e.g. refinements or
 * object classes)
 *
 * File: AbstractUISetEditor.java
 * @author Jussi Stader
 * @version 4.3
 * Updated: Mon Jan 29 13:57:48 2007
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.iview;

import java.util.*;
import java.lang.reflect.Field;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.JOptionPane;
import javax.swing.JFileChooser;
import java.io.*;

import ix.iview.*;
import ix.iview.util.*;
import ix.iview.event.*;
import ix.iview.domain.*;
import ix.iview.domain.event.*;
import ix.icore.domain.event.*;
import ix.icore.*;
import ix.icore.domain.*;
import ix.iface.domain.*;
import ix.iface.ui.*;
import ix.iface.ui.util.*;
import ix.iface.ui.event.*;
import ix.util.*;
import ix.util.match.*;
import ix.util.lisp.*;

/**
 * Support for editing sets of named objects (e.g. refinements or
 * object classes).  Looks after adding/removing/editing the objects
 * and keeping the set consistent. Handles overwrites, finding objects
 * in the set, working out whether the set has changed.
 */

public class UIRefinementSetEditor extends AbstractUISetEditor
{ 

  public boolean lazyOwn = true;

  public UIRefinementSetEditor(DomainObjectManager om, LinkedList os) {
    super(om, os);
    label = "refinement"; // set for messages
  }

  public void setLegalName(Object object, String name) {
    try {
      ((UIRefinement)object).setLegalName(name);
    }
    catch (Exception e) {}
  }
  public boolean isOwnObject(Object object) {
    return (object instanceof UIRefinement);
  } 
  public boolean sameConstruct(Object r, Object rOther) {
    if ((r instanceof Refinement) && (rOther instanceof Refinement)) {
      Refinement one = (Refinement)r;
      Refinement other = (Refinement)rOther;
      return (one.getName().equals(other.getName())
	      && one.getPattern().equals(other.getPattern())
	      && one.getVariableDeclarations().
	      equals(other.getVariableDeclarations())
	      && one.getNodes().equals(other.getNodes())
	      && one.getOrderings().equals(other.getOrderings())
	      && one.getConstraints().equals(other.getConstraints())
	      && one.getIssues().equals(other.getIssues())
	      && one.getComments().equals(other.getComments())
	      && one.getAnnotations().equals(other.getAnnotations()));
    }
    else return false; //***cannot compare
  }

    public LinkedList getOriginals() {
	return getDomainOriginals();
    }

  public LinkedList getDomainOriginals() {
    //Debug.noteln("Getting domain originals", 
    //getDomain().getRefinements().size());
    try {
      return new LinkedListOfRefinement(getDomain().getRefinements());  
    }
    catch (Exception e) {
      return null;
    }
  }

  public LinkedList makeOriginalList() {
    return new LinkedListOfRefinement();
  }
 
  public Object makeOwnObject(Object object) {
    if (object == null) return null;
    if (object instanceof Refinement) {
      Object own =
	new UIRefinement(((DomainObjectManager)manager).getUIDomain(), 
			 (Refinement)object);
      return own;
    }
    else {
      Debug.noteln("WARNING - UIRE: cannot make own object from", object);
      return null;
    }
  }

  public Named getStringOriginal(String name) {
    Named orig = null;
    if (getDomain() != null)
      orig = getDomain().getNamedRefinement(name); 
    return orig;
  }
  
  public HashSet getMatchingUIRefinements(LList pattern, List domainMatches) {
    UIDomain uiDomain = ((DomainObjectManager)manager).getUIDomain();
    HashSet uiMatches = new HashSet(domainMatches);
    //check domain matches for removed or edited ones
    for (Iterator i = domainMatches.iterator(); i.hasNext(); ) {
      Refinement r = (Refinement)i.next();
      if (removed.contains(r)) uiMatches.remove(r);
      else {
	Named uio = (Named)findOwnObject(r);
	if (uio != null)  //ui version exists, so forget the domain version
	  uiMatches.remove(r); 
	else if (uiDomain.isMatchingRefinement(pattern, r))
	  uiMatches.add(r);
      }
    }
    //now add the UI ones that match
    HashSet uios = new HashSet(originals.values());
    uios.addAll(added);
    for (Iterator i = uios.iterator(); i.hasNext(); ) {    
      Object next = i.next();
      try {
	UIRefinement uir = (UIRefinement)next;
	//Debug.noteln("UID: Checking uir for match", uir);
	if (uiDomain.isMatchingRefinement(pattern, uir)) 
	  uiMatches.add(uir);
      }
      catch (Exception e) {
	Debug.describeException(e);
      }
    }
    return uiMatches;
  }
  /*
  public HashSet getMatchingRefinements(LList pattern) {
    UIDomain uiDomain = ((DomainObjectManager)manager).getUIDomain();
    List refs = uiDomain.getAllRefinements();
    HashSet uiMatches = new HashSet(refs);
    //check domain matches for removed or edited ones
    for (Iterator i = refs.iterator(); i.hasNext(); ) {
      Object r = i.next();
      if ((r == null) || removed.contains(r)) uiMatches.remove(r);
      else {
	Named uio = (Named)findOwnObject(r);
	if (uio != null)  //ui version exists, so forget the domain version
	  uiMatches.remove(r); 
	else if (uiDomain.isMatchingRefinement(pattern, r))
	  uiMatches.add(r);
      }
    }
    //now add the UI ones that match
    HashSet uios = new HashSet(originals.values());
    uios.addAll(added);
    for (Iterator i = uios.iterator(); i.hasNext(); ) {    
      Object next = i.next();
      try {
	UIRefinement uir = (UIRefinement)next;
	//Debug.noteln("UID: Checking uir for match", uir);
	if (uiDomain.isMatchingRefinement(pattern, uir)) 
	  uiMatches.add(uir);
      }
      catch (Exception e) {
	Debug.describeException(e);
      }
    }
    return uiMatches;
  }
  */
  public HashSet getMatchingRefinements(LList pattern, List refs) {
    UIDomain uiDomain = ((DomainObjectManager)manager).getUIDomain();
    //List refs = uiDomain.getAllRefinements();
    //Debug.noteln("UIRSetEd: looking for", pattern);
    //Debug.noteln(" in refs", IVUtil.namedListToDisplay(refs));
    HashSet uiMatches = new HashSet();
    //check domain matches for removed or edited ones
    for (Iterator i = refs.iterator(); i.hasNext(); ) {
      Object r = i.next();
      //Debug.noteln(" checking", r);
      if ((r != null) && !removed.contains(r)) {
	Named uio = (Named)findOwnObject(r);
	if (uio == null)  uio = (Named)r; //no own, so try original
	//Debug.noteln("   checking", uio);

	if (uiDomain.isMatchingRefinement(pattern, uio))
	  uiMatches.add(uio);
      }
      //else Debug.noteln(" must be in removed", UIUtil.show(removed));
    }
    return uiMatches;
  }

}


// Issues:
// * tidy up load/insert domain stuff 
// * 
// * 
