/****************************************************************************
 * A minimal editor/viewer panel for making dummy panels
 *
 * @author Jussi Stader
 * @version 2.3+
 * Updated: Mon Apr  3 11:21:26 2006
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview;

import java.util.List;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;

import ix.*;
import ix.util.Debug;
import ix.util.Util;
import ix.util.lisp.*;
import ix.icore.domain.*;
import ix.iface.*;
import ix.iface.ui.util.*;
import ix.iview.*;
import ix.iview.domain.*;

/****************************************************************************
 * A minimal editor/viewer panel for making dummy panels
 *
 * Waiting to be implemented. <p>
 * Example code for using the SimpleEditorPanel:
 *<PRE><code>
 *    ...
 *    ...
 *</code></PRE>
 *****************************************************************************
 */
public class SimpleEditorPanel extends AConstructFramePanel
   implements ActionListener
{
  /** 
   * Make a new construct of the panel's type and get ready to edit it.
   */
  public void newConstruct() {
    UIUtil.notImplemented(this,"Making a new construct");
  }
  public UIObject makeNewConstruct() {
    return null;
  }
  /** 
   * Save a construct of the panel's type into the draft domain.
   */
  public void saveConstruct() {
    UIUtil.notImplemented(this,"Saving a construct");
  }
  /** 
   * Note the contents of the panel into the current object.
   */
  public UIObject noteConstruct() {
    UIUtil.notImplemented(this,"Noting panel changes");
    return null;
  }
  /** 
   * Get a named construct of the panel's type from the domain
   */
  public Named getNamedConstruct(String name) {
    return null;
  }
  /** 
   * Put a given construct of the panel's type into the panel ready for editing
   */
  public void setConstruct(UIObject construct) {
    UIUtil.notImplemented(this,"Setting a construct");
  }
  /** 
   *  Check a construct of the panel's type for errors and inconsistencies
   */
  public boolean checkConstruct() {
    UIUtil.notImplemented(this,"Checking construct");
    return true;
  }
  /** 
   * Get a full list of the constructs of the panel's type in the domain.
   */
  public List getAllConstructs() {
    return null;
  }

  protected UIObject cloneConstruct(UIObject uiConstruct) {
    return null;
  }


  /**
   * Dummy - Creates a JPanel
   */    
  public SimpleEditorPanel(){
    super();
  }

  protected JPanel setupMainPanel() {
    return new JPanel();
  }

  public void refresh() {}

  public boolean frameActionPerformed(ActionEvent event){
    String command = event.getActionCommand();
    if (command == "newConstruct") newConstruct();
    else if (command == "editConstruct") {
      //***dummy
    }
    else if (command == "saveConstruct") saveConstruct();
    else if (command == "checkConstruct") checkConstruct();
    else return false;
    return true;
  }


  /**
   * Wakes up the ActionListener with a user action.
   * This is called when a KeyStroke happens in which the ActionListener
   * registered its interest.
   */
  public void actionPerformed(ActionEvent ae){
    String command = ae.getActionCommand();
    Debug.noteln("SEP: Got action command", command);
  }

}

/*Issues***************************************************************
 *
 * implement this?
 *
/*Todos***************************************************************
 *
 *****************************************************************************
 */
