/****************************************************************************
 * A manager for application properties
 *
 * @author Jussi Stader
 * @version 3.1
 * Updated: Mon Sep  4 13:58:53 2006
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview;

import ix.*;
import ix.util.*;
import ix.util.lisp.*;
import ix.iface.ui.*;
import ix.iface.ui.util.*;

import java.io.*;
import java.util.*;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Component;
import java.awt.event.*;
import javax.swing.*;


/**
 * A manager for properties/preferences of the I-X Domain Editor, I-DE.
 *
 * Remember to mark properties that cannot be edited here as such using the
 * noteNoEditable method, otherwise such preperties will be emptied.
 */
public class IDEPropertiesManager extends JPropertiesManager
  implements IDESymbols
{
  public IDEPropertiesManager(PropertiesApplication application) {
    super(application);
    noteNoEditable("ideX");
    noteNoEditable("ideY");
    noteNoEditable("ideWidth");
    noteNoEditable("ideHeight");
  }
  public void setDefaultProperties(Properties defaults) {
    defaults.setProperty("idePanelStyle", "tabbed");
    defaults.setProperty("ideActivityView", VIEW_COMPREHENSIVE.toString());
    defaults.setProperty("ideShowButtonTexts", 
			 new Boolean(true).toString());
    defaults.setProperty("ideEditable", new Boolean(true).toString());
    defaults.setProperty("ideListsAsTexts", 
			 new Boolean(true).toString());
    defaults.setProperty("ideConstraints", C_ALL.toString());
    Symbol mode = MODE_SIMPLE;
    defaults.setProperty("ideMode", mode.toString());
    defaults.setProperty("ideNewCondEditor", new Boolean(true).toString());
    defaults.setProperty("ideX", Integer.toString(100));
    defaults.setProperty("ideY", Integer.toString(100));
    defaults.setProperty("ideWidth", Integer.toString(850));
    defaults.setProperty("ideHeight", Integer.toString(650));
  }

  public File getPropertiesFile() {
    String folder = ".";
    String filesep = System.getProperty("file.separator");
    String filename = folder + filesep + "ide.prefs";
    return new File(filename);    
  }

  public JPreferencesDialog makePreferencesDialog() {
    return new IDEPreferencesDialog((DomainEditorFrame)application.getFrame(), 
				    this);
  }

}
