/****************************************************************************
 * An interface model to be used to fill an IFormPanel.
 *
 * @author Jussi Stader
 * @version 2.0
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview;

import ix.*;
import ix.util.Debug;
import ix.util.lisp.*;
import ix.icore.domain.*;
import ix.icore.*;
import ix.iface.ui.*;
import ix.iview.domain.*;

import java.util.*;
//import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * An default model to be used to fill an IFormPanel.
 *
 */
public class DomainFormModel extends GenericIFormModel {

  public DomainFormModel() {
    super(UIDomain.class);
  }
  public DomainFormModel(EditableObject object) {
    super(object);
  }

  protected Class deriveClass(String field) {
    if (field.equals("refinements") || field.equals("objectClasses")) 
      return List.class;
    //if (field.equals("annotations")) return Annotations.class;
    else return super.deriveClass(field);
  }

  protected List deriveDisplayFields() {
    //get the class to work with
    List fields = super.deriveDisplayFields();
    fields.add("refinements");
    fields.add("objectClasses");
    //fields.add("annotations");
    return fields;
  }

  public Object getValue(String field) {
    if (baseObject == null) {
      Debug.noteln("Cannot get value for a null base object.");
      return null;
    }
    else if (field.equals("refinements")) {
      UIDomain uiDomain = (UIDomain)baseObject;
      return uiDomain.getAllRefinements();
    }
    else if (field.equals("objectClasses")) {
      UIDomain uiDomain = (UIDomain)baseObject;
      return uiDomain.getAllObjectClasses();
    }
    else return super.getValue(field);
   } 
  public void setValue(String field, Object value) {
    if (!field.equals("refinements") && !field.equals("objectClasses")) 
      super.setValue(field, value);
   } 
  public boolean setValue(EditableObject object, String field, Object value) {
    if (!field.equals("refinements") && !field.equals("objectClasses")) 
      return super.setValue(object, field, value);
    else return true;
   } 

}
