/****************************************************************************
 * An interface to be implemented by any FramePanel that is part of a
 * DomainEditor
 *
 * @author Jussi Stader
 * @version 4.1
 * Updated: Mon Jan 17 08:55:34 2005
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview;

import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.*;       
import java.awt.event.ActionEvent;
import ix.*;
import ix.util.Debug;
import ix.util.Util;
import ix.util.lisp.*;
import ix.icore.*;
import ix.icore.domain.*;
import ix.iface.ui.*;
import ix.iface.domain.*;
import ix.iview.*;
import ix.iview.domain.*;

/****************************************************************************
 * An interface to be implemented by any FramePanel that is part of a
 * DomainEditor
 *****************************************************************************
 */
public interface ConstructFraming extends FramePanel
{

  /** Gets the current Domain. */
  public Domain getDomain();

  /** Gets the current UIDomain. */
  public UIDomain getUIDomain();

  /** Sets the current UIDomain. */
  public void setUIDomain(UIDomain uiDomain);

  /** Makes a new construct of the panel's type and gets ready to edit it. */
  public void newConstruct();

  /** Makes a new construct of the panel's type. */
  public UIObject makeNewConstruct();

  /** Notes the content of the editing panel into the current(new?) UIObject.
  * This is part of the interface because it should be remembered!!
  **/
  //public UIObject noteConstruct();

  /** Saves a construct of the panel's type into the draft domain. */
  public void saveConstruct();

  /** Gets a named construct of the panel's type from the domain */
  public Named getNamedConstruct(String name);

  /** 
   * Puts a given domain construct of the panel's type into the panel ready
   * for editing
   */
  public void setConstruct(IXObject construct);

  /** 
   * Put a given UI construct of the panel's type into the panel ready for
   * editing
   */
  public void setUIConstruct(UIObject construct);

  /** Checks a construct of the panel's type for errors and inconsistencies. */
  public boolean checkConstruct();

  /** Collects the construct's changes since last noted to draft (to base
   * object) and shows them to the user. 
   */
  public void viewChanges();
  /** Collects the construct's changes since last published 
   * and shows them to the user. 
   */
  public void viewChangesFromOriginal();

  /** Gets a full list of the constructs of the panel's type in the domain. */
  public List getAllConstructs();

  /**
   * Tries to process an action generated in the panel's frame. 
   * @return true if the event is recognised, false if not.
   */
  public boolean frameActionPerformed(ActionEvent event);


}



/*Issues***************************************************************
 *
/*Todos***************************************************************
 *
 *
 *****************************************************************************
 */
