/****************************************************************************
 * An interface to be implemented by any panel that actually edits a construct.
 *
 * @author Jussi Stader
 * @version 3.1
 * Updated: Mon Oct 24 13:58:46 2005
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *****************************************************************************
 */
package ix.iview;

import ix.icore.*;
import ix.iview.domain.*;
import ix.iface.ui.EditableObject;

/****************************************************************************
 * An interface to be implemented by any panel that actually edits a construct.
 * Examples are ActionFormEditor and GExpansionEditor.
 *****************************************************************************
 */
public interface ConstructEditing 
{
  
  /** Gets the current UIDomain. */
  public UIDomain getUIDomain();

  /** Gets the current construct. */
  public IXObject getConstruct();

  /** Sets the current construct. */
  public void setConstruct(IXObject construct);

  /** Gets the current UI construct. */
  public UIObject getUIConstruct();

  /** 
   * Sets the current UI construct.
   * Remember to parent.fireConstructChanged(old, new)
   */
  public void setUIConstruct(UIObject construct);

  /** Sets the current UI construct without noting changes.
   * Remember to parent.fireConstructChanged(old, new)
   */
  public void setUIConstructOnly(UIObject construct);

  /** Saves the data from the panel into the given object. */
  public void saveToObject(EditableObject object);

  /** Saves the data from the panel into the current object. */
  public void loadFromObject();

}

/*Issues***************************************************************
 */
/*Todos***************************************************************
 *****************************************************************************
 */
