/****************************************************************************
 * An interface model to be used to fill an IFormPanel.
 *
 * @author Jussi Stader
 * @version 4.0+
 * Updated: Wed Jan 11 09:43:45 2006
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview;

import ix.*;
import ix.util.Debug;
import ix.util.lisp.*;
import ix.iface.ui.*;
import ix.icore.domain.*;
import ix.iview.domain.*;
import ix.iview.util.*;

import java.util.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * An default model to be used to fill an IFormPanel.
 *
 */
public class ActionFormModel extends GenericIFormModel {
  private static String miniC = "miniConstraints";
  private final DomainEditorFrame ideFrame;

  public ActionFormModel(DomainEditorFrame ideFrame) {
    super(UIRefinement.class);
    this.ideFrame = ideFrame;
  }
  public ActionFormModel(DomainEditorFrame ideFrame, Class objectClass) {
    super(objectClass);
    this.ideFrame = ideFrame;
  }
  public ActionFormModel(DomainEditorFrame ideFrame, EditableObject object) {
    super(object);
    this.ideFrame = ideFrame;
  }

  protected Class deriveClass(String field) {
    if (field.equals(miniC)) 
      return String.class;
    else if (field.equals("conditions")) 
      return super.deriveClass("constraints");
    else if (field.equals("constraints")) 
      return super.deriveClass("constraints");
    else return super.deriveClass(field);
  }
  protected String deriveName(String field) {
    if (field.equals(miniC)) 
      return "Orderings";
    if (field.equals("conditions")) 
      return "Conditions/Effects";
    if (field.equals("constraints")) 
      return "Other Constraints";
    else return super.deriveName(field);
  }


  protected List deriveDisplayFields() {
    //get the class to work with
    List fields = super.deriveDisplayFields();
    fields.add(miniC);
    fields.add("conditions");
    fields.add("constraints");
    return fields;
  }

  public Object getValue(String field) {
    if (baseObject == null) {
      Debug.noteln("Cannot get value for a null base object.");
      return null;
    }
    else {
      if (field.equals(miniC)) {
	UIRefinement uir =  (UIRefinement)baseObject;
	return uir.getOrderingType();
      }
      //if miniC is showing, turn orderings into miniC
      else if (field.equals("orderings") && isFieldShowing(miniC)) {
	UIRefinement uir =  (UIRefinement)baseObject;
	return uir.getOrderingType();
      }
      else if (field.equals("conditions")) {
	//Debug.noteln("Getting conditions");
	UIRefinement uir =  (UIRefinement)baseObject;
	return uir.getConditions();
      }
      else if (field.equals("constraints")) { 
	UIRefinement uir =  (UIRefinement)baseObject;
	return getOtherConstraints(uir);
      }
      else return super.getValue(field);
    }
  }

  public double getFieldWeight(String field) {
    if (field.equals(miniC) || field.equals("pattern")) return 0.1;
    else return super.getFieldWeight(field);
  }
  //make pattern and name fields line up
  public String getFieldName(String field) {
    if (field.equals("name")) return "Name  ";
    else return super.getFieldName(field);
  }

  private List getOtherConstraints(UIRefinement uir) {
    if (IDEUtil.showConditions(ideFrame.preferredConstraints))
      return uir.getOtherConstraints();
    else return uir.getConstraints();
  }
  private void setOtherConstraints(UIRefinement uir, List value) {
    if (IDEUtil.showConditions(ideFrame.preferredConstraints))
      uir.setOtherConstraints(value);
    else uir.setConstraints(value);
  }


  /**
   * setValue(String field, Object value) calls this too, so only implement one
   * The miniC settings are dealt with as they happen 
   */
  public boolean setValue(EditableObject o, String field, Object value) {
    //Debug.noteln("AFM: got value for field", field);
    //Debug.noteln(" value of type", value.getClass());
    if (field.equals(miniC)) {
      try {
	List oldValue = ((UIRefinement)o).getOrderings();
	((UIRefinement)o).setOrderingType((String)value);
	List newValue = ((UIRefinement)o).getOrderings();
	if (!((UIRefinement)o).sameValue("orderings", oldValue, newValue)) {
	  fireDataChanged(field, o, oldValue, newValue);
	}
	return true;
      }
      catch (Exception e) {
	Debug.noteException(e);
	return false;
      }
    }
    /*
    else if (field.equals("nodes")) {
      try { 
	((UIRefinement)o).updateNodes((List)value); 
	//Debug.noteln("AFM: setting nodes");
	return true;
      }
      catch (Exception e) {
	Debug.noteException(e);
	return super.setValue(o, field, value);
      }
    }
    else if (field.equals("issues")) {
      try { 
	((UIRefinement)o).setIssues((List)value); 
	return true;
      }
      catch (Exception e) {
	Debug.noteException(e);
	return super.setValue(o, field, value);
      }
    }
    else if (field.equals("conditions")) {
      UIRefinement uir =  (UIRefinement)o;
      uir.setConditions((List)value);
      return true;
    }
    */
    else if (field.equals("constraints")) {
      //sometimes these are only other constraints, sometimes all!
      UIRefinement uir =  (UIRefinement)o;
      setOtherConstraints(uir, (List)value);
      return true;
    }
    else return super.setValue(o, field, value);
  }
}
