/****************************************************************************
 * An interface to be implemented by any panel that actually edits a construct.
 *
 * @author Jussi Stader
 * @version 2.0
 * Updated: Mon Oct 24 14:11:35 2005
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *****************************************************************************
 */
package ix.iview;

import ix.icore.*;
import ix.iview.domain.*;
import ix.iface.ui.EditableObject;
import javax.swing.JPanel;

/****************************************************************************
 * An interface to be implemented by any panel that actually edits a construct.
 * Examples are ActionFormEditor and GExpansionEditor.
 *****************************************************************************
 */
public abstract class AConstructEditorPanel extends JPanel 
implements ConstructEditing {
  
  protected AConstructFramePanel parent;
  protected UIObject uiConstruct;

  /** Gets the current UIDomain. */
  public UIDomain getUIDomain() { 
    return parent.getUIDomain();
  }
  /** Gets the current construct. */
  public IXObject getConstruct() { 
    return uiConstruct.getBaseObject(); 
  }
  /** Sets the current construct. */
  public void setConstruct(IXObject construct) {
    setUIConstruct(getUIDomain().getUIObject(construct));
  }
  /** Gets the current UI construct. */
  public UIObject getUIConstruct() { 
    return uiConstruct; 
  }

  /**
   * Sets the current UI construct in the panel.
   * Remember to parent.fireConstructChanged(old, new, this);
   */
  public abstract void setUIConstruct(UIObject construct);
  /** Saves the data from the panel into the given object. */
  public abstract void saveToObject(EditableObject object);

}

/*Issues***************************************************************
 */
/*Todos***************************************************************
 *****************************************************************************
 */
