/****************************************************************************
 * An interface for user objects that have parents and children
 *
 * File: IXNode.java
 * @author Jussi Stader
 * @version 2.0
 * Updated: Mon Apr 10 13:31:34 2006
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.iface.ui.tree;

import java.util.List;

public interface IXNode {

  public List getParents();
  public List getChildren();

  public void addChild(IXNode child);
  public void addParent(IXNode parent);

  public void removeChild(IXNode child);
  public void removeParent(IXNode parent);

}
