/****************************************************************************
 * An abstract class for wrapping data objects in tree table models.
 *
 * @author Jussi Stader
 * @version 2.3+
 * Updated: Mon Oct  7 10:26:37 2002
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui.table;

import ix.util.*;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.util.*;

/**************************************************************************
 * An abstract class that is wrapped around objects to provide the TreeNode
 * interface and to hold information about identity in the tree (parent-line)
 * and expansion information (indentation, the node is expanded or not). <p>
 *
 * Implement the TreeNode interface in any non-abstract sub-class. Use
 * IXTNTreeTableNode for wrapping TreeNode objects.
 *
 **************************************************************************
 */
public abstract class IXTreeTableNode extends Object implements TreeNode {
  public Object node;
  public LinkedList parentLine;
  public int indent = 0;
  public boolean expanded = false;
  public List kids = new ArrayList(); //child tree nodes added by expandNode
  public AbstractTreeTableModel model;
  
  public IXTreeTableNode(AbstractTreeTableModel model, Object theNode) {
    this(model, theNode, null);
  }
  public IXTreeTableNode(AbstractTreeTableModel model, 
			 Object theNode, List theParents) {
    node = theNode;
    this.setParents(theParents);
    this.model = model;
    model.addTreeNode(theNode, this);
    
  }
  public IXTreeTableNode(AbstractTreeTableModel model, 
			 Object theNode, List theParents, int n) {
    this(model, theNode, theParents);
    indent = n;
  }
  public void setExpanded(boolean isExpanded) {
    expanded = isExpanded;
  }
  public void setParents(List parents) {
    if (parents == null) parentLine = new LinkedList();
    else parentLine = new LinkedList(parents);
  }
  public List getParents() {
    return parentLine;
  }
  

  public boolean equals(IXTreeTableNode n) {
    if (node.equals(n.node)) {
      if (parentLine.equals(n.parentLine)) {
	//Debug.noteln("IXTTN: nodes equal!", this);
	return true;
      }
      //else Debug.noteln("IXTTN: parents differ", this + " / " + n);
    }
    //else Debug.noteln("IXTTN: nodes differ", this + " / " + n);
    return false;
  }
  public String toDebug() {
    String e = " expanded";
    if (!expanded) e = " not" + e;
    return node.toString() + e;
  }
}

