/****************************************************************************
 * Abstract tree table, as IXTable but for tree structures.
 * 
 * @author Jussi Stader
 * @version 2.3
 * Updated: Mon Sep 25 09:39:18 2006
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 ****************************************************************************
 */
package ix.iface.ui.table;


import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import javax.swing.tree.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

import ix.iface.ui.NeutralIconRenderer;
//import ix.iface.ui.*;
import ix.iface.ui.table.event.*;
import ix.util.Debug;
//import ix.util.*;

/****************************************************************************
 * Abstract table, as IXTable but for tree structures.
 * displays tree information in an icon-column, and indents the first column 
 * to show tree structure. <p>
 *
 * IXTreeTable is used to provide a standard table behaviour for tree
 * structures with added details. It can display tree information in a 
 * neutral icon-column, and the model will help toindents the first column 
 * to show tree structure.
 * Uses an AbstractTreeTableModel (which manipulates TreeNodes). <p>
 *
 * Example code for making a TreeTable happen:
 * <PRE><code>
 * ...
 *   TreeNode[] tna = {};
 *   TreeNode[] nodes = domain.getAllRefinements().toArray(tna);
 *   ActionTreeTableModel tableModel = new ActionTreeTableModel(domain, nodes);
 *   // or simply: tableModel = new ActionTreeTableModel(domain);
 *   IXTable table = new IXTreeTable(tableModel);
 *   table.setPreferredScrollableViewportSize(new Dimension(200, 100));
 *   JScrollPane jsp = new JScrollPane();
 *   jsp.getViewport().add(table);
 *   panel.add(jsp);
 * ...
 * </code></PRE>
 ****************************************************************************
 */

public class IXTreeTable extends IXTable 
implements TreeTableStructureListener {

  public IXTreeTable(){
    //    Insets ins = getInsets();
    //    setSize(ins.left + ins.right + 430,ins.top + ins.bottom + 270);
    super();
    setTreeTypeRenderer();
  }

  /** 
   * Makes a table and sets the given model, adjusts column widths, registers
   * model as mouse listener (if appropriate).
   */
  public IXTreeTable(AbstractTreeTableModel model) {
    super(model);
    model.addTreeTableModelListener(this);
    setTreeTypeRenderer();
  }

  /**
   * Sets the model which must ba an AbstractTreeTableModel
   */
  public void setModel(TableModel model) {
    super.setModel(model);
    //Debug.noteln("IXTT: got model of class", model.getClass());
    try { 
      ((AbstractTreeTableModel)model).addTreeTableModelListener(this); 
      //Debug.noteln("IXTT: got good model for this", this);
    }
    catch (Exception e) {    }
  }

  /** 
   * Neutral icon renderer, used for treeIconColumn, perhaps others.
   */
  private void setTreeTypeRenderer() {
    //Debug.noteln("IXTT: Setting neutral icon renderer");
    JTableHeader header = getTableHeader();
    this.setDefaultRenderer(ImageIcon.class, 
			    new NeutralIconRenderer(false, header));
  }

  /**
   ****** bold making is now in AbsTTModel
   * Reacts to new tree structure by updating nameColumn, making it bold for
   * parents.
   */
  public void treeStructureChanged() {
  }

  /**
   ****** bold making is now in AbsTTModel
   * Reacts to new node structure by updating nameColumn, making it bold if
   * the node is a parent, plain if it is a leaf node.
   */
  public void nodeStructureChanged(IXTreeTableNode node) {
  }

}

/**
Changes:
    14/01/03: 
	- parameterised location of treeIconColumn and indentNameColumn 
	  (in makeBold)
	- added comments
*/

/**


 ***BUG!! Makes things hang in refresh
  public Object getValueAt(int row, int col) {
    if ((parentsAreBold) && (col == 1)) {
      try {
	AbstractTreeTableModel model = (AbstractTreeTableModel)getModel();
	TreeNode node = (TreeNode)model.getRowNode(row);
	Rectangle rect = getCellRect(row, col, false);
	int x = (int)rect.getX();
	int y = (int)rect.getY();
	Component comp = findComponentAt(x, y);
	if (node.isLeaf()) 
	  comp.setFont(comp.getFont().deriveFont(Font.PLAIN));
	else
	  comp.setFont(comp.getFont().deriveFont(Font.BOLD));
      }
      catch (Exception e) {}
    }
    return super.getValueAt(row, col);
  }

*/
