/****************************************************************************
 * NeutralIconRenderer - icon renderer with background as given component.
 * 
 * @author Jussi Stader
 * @version 1.0
 */
package ix.iface.ui;

import ix.*;
import ix.util.Debug;

import java.awt.Color;
import javax.swing.*;
import javax.swing.table.*;


/****************************************************************************
 * NeutralIconRenderer - icon renderer with background as given component.
 * 
 * Useful e.g. for expand/collapse icons in tables (look like part of the 
 * table's format).
 *
 ****************************************************************************
 */
public class NeutralIconRenderer extends IconRenderer { 
  JComponent conponent;
  /** 
   * Makes a label with or without a border.
   * If colour is used, the border can reflect whether the cell is selected.
   * @param isBordered determines whether the cell has a border or not.
   */
  public NeutralIconRenderer(boolean isBordered, JComponent theComponent) {
    super(isBordered);
    conponent = theComponent;
  }
    
  public void setInfo(Object icon) {
    this.setIcon((Icon)icon);
    this.setBackground(conponent.getBackground());
  }

}

