/****************************************************************************
 * NDRenderer - uses text, colour, image and a symbol to display information.
 * 
 * @author Jussi Stader
 * @version 1.0
 */
package ix.iface.ui;

import ix.*;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.ImageIcon;


/****************************************************************************
 * IconRenderer - uses text, colour, image and a symbol to display information.
 * 
 * A IconRenderer can be used for table cells and list cells.
 * It expects to use an Icon
 * The cell can have a border to reflect whether the cell is selected when 
 * the cell has a background colour.
 * The border is used to show whether the cell/row is selected or not.
 * Borders are managed by the IXRenderer.
 *
 ****************************************************************************
 */
public class IconRenderer extends IXLabelRenderer { 
  /** 
   * Makes a label with or without a border.
   * If colour is used, the border can reflect whether the cell is selected.
   * @param isBordered determines whether the cell has a border or not.
   */
  public IconRenderer(boolean isBordered) {super(isBordered);}

    
  public void setInfo(Object icon) {
    this.setIcon((Icon)icon);
    this.setText("");
  }

}

