/****************************************************************************
 * An interface model to be used to fill an IFormPanel.
 *
 * @author Jussi Stader
 * @version 2.0
 * Updated: Mon Jun 30 15:52:37 2003
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui;

import ix.*;
import ix.util.Debug;
import ix.util.lisp.*;
import ix.iface.ui.event.*;

import java.util.*;
import java.lang.reflect.*;
//import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * An interface model to be used to fill an IFormPanel.
 *
 */
public interface IFormModel {

  /**
   * Gets the names of the object's fields that are to be shown as its name
   */
  public List getNameFields();
  /**
   * Gets the names of the object's fields that are to be displayed
   * (exc. names)
   */
  public List getDisplayFields();


  /**
   * Sets the fields of the object that are to be shown as its name.
   * @param nameFields a list of strings; the field names
   */
  public void setNameFields(List nameFields);
  /**
   * Sets the fields of the object that are to be shown as its name.
   * @param nameFields an array of strings; the field names
   */
  public void setNameFields(String[] nameFields);
  /**
   * Sets the fields of the object that are to be displayed (exc. names)
   * @param nameFields a list of strings; the field names 
   */
  public void setDisplayFields(List nameFields);
  /**
   * Sets the fields of the object that are to be shown as its name.
   * @param nameFields an array of strings; the field names
   */
  public void setDisplayFields(String[] nameFields);

  /**
   * Gets the title to use for the object's given field (e.g. "Name", "Id")
   */
  public String getFieldName(String f);
  /**
   * Gets the class of the object's given field name 
   * (e.g. String.class, Object.class)
   */
  public Class getFieldClass(String f);
  /**
   * Gets the weight of the object's given field name to establish its portion of
   * the display.
   */
  public double getFieldWeight(String field);

  /**
   * Set the model's base object
   */
  public void setObject(EditableObject o);
  /**
   * Get the model's current base object
   */
  public EditableObject getObject();


  /**
   * Gets the class of the model's base object
   */
  public Class getObjectClass();


  /**
   * Gets the current object's value for the given field name.
   */
  public Object getValue(String field);
  /**
   * Sets the current object's given field to the given value.
   */
  public void setValue(String field, Object value);
  /**
   * Sets the given object's given field to the given value.
   */
  public boolean setValue(EditableObject object, String field, Object value);
  
  /**
   * Clears the model of its data;
   */
  public void clearData();
  
  /**
   * Determines whether a field is editable (can be changed by the user) 
   * or not.
   */
  public boolean isEditable(String field);

  /**
   * Determines whether the given field is part of the model display.
   */
  public boolean isFieldShowing(String field);

  public void startUpdate();
  public void endUpdate();
  public void ignoreUpdate();

  public void addModelListener(FormModelListener l);
  public void addDataListener(FormDataListener l);

  public HashSet getModelListeners();
  public HashSet getDataListeners();
}
