/****************************************************************************
 * A frame with a menu bar to close it, and a scrollable text 
 *
 * @author Jussi Stader
 * @version 4.0+
 * Updated: Mon Nov  8 12:51:52 2004
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui;

import ix.*;
import ix.util.*;
import ix.iface.util.*;
import ix.iface.ui.util.*;

import java.util.*;
import java.awt.*;
import java.net.URL;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 * A frame with a menu bar to close it, and a scrollable text 
 */
public class HTMLFrame extends ToolFrame implements ActionListener
{
  
  private URL home;
  final protected HTMLPanel htmlPanel;

  /**
   * Puts up a frame with a menu bar and a scrollable text area that can
   * display HTML (including images), follow links when clicked, and select
   * text, but NOT edit. Will let the user go back and forward between
   * previously displayed HTMLs.
   *
   * Above the text area, there is a text-field for typing in a URL and
   * a button to load the URL reference into the text area.
   */
  public HTMLFrame(){
    super();
    setupFrame();
    htmlPanel = new HTMLPanel();
    addHTML();
  }
  /**
   * As above but comes up with the given url displayed
   */
  public HTMLFrame(URL url){
    super();
    setupFrame();
    htmlPanel = new HTMLPanel(url);
    addHTML();
    home = htmlPanel.currentURL();
  }

  /**
   * As above but the given URL is displayed and remembered as the original
   * page.
   */
  public HTMLFrame(URL url, String title){
    this(url);
    setTitle(title);
  }
  /**
   * As above but the given file name is converted to a URL using the html
   * area of the resources. 
   * An example call is <code> HelpFrame("ide-help.html") <\code>
   */
  public HTMLFrame(String fileName){
    super();
    setupFrame();
    htmlPanel = new HTMLPanel(fileName);
    addHTML();
    home = htmlPanel.currentURL();
  }
  /**
   * As above but the given file name is converted to a URL using the html
   * area of the resources. 
   * An example call is <code> HelpFrame("ide-help.html") <\code>
   */
  public HTMLFrame(String fileName, String title){
    this(fileName);
    setTitle(title);
  }
   	
  protected void setupFrame() {
    getContentPane().setLayout(new BorderLayout(0,0));
    setSize(550,650);
    //setIconImage(IconImage.getIconImage("ip2-help-icon.gif"));

    CatchingActionListener catchListen = new CatchingActionListener(this);

    JMenuBar menuBar = new JMenuBar();
    setJMenuBar(menuBar);
    JMenu fileMenu = new JMenu("File");	 
    menuBar.add(fileMenu);
    JMenuItem item = new JMenuItem("Close");	 
    item.setActionCommand("close");
    item.addActionListener(catchListen);
    JMenuItem itemF = new JMenuItem("Forward to previous page");	 
    itemF.setActionCommand("forward");
    itemF.addActionListener(catchListen);
    JMenuItem itemB = new JMenuItem("Back to previous page");	 
    itemB.setActionCommand("back");
    itemB.addActionListener(catchListen);
    JMenuItem itemH = new JMenuItem("Home");	 
    itemH.setActionCommand("home");
    itemH.addActionListener(catchListen);
    JMenuItem itemSH = new JMenuItem("Set current page as home");	 
    itemSH.setActionCommand("setHome");
    itemSH.addActionListener(catchListen);
    fileMenu.add(itemH);
    fileMenu.add(itemB);
    fileMenu.add(itemF);
    fileMenu.addSeparator();
    fileMenu.add(itemSH);
    fileMenu.addSeparator();
    fileMenu.add(item);
  }

  private void addHTML() {
    getContentPane().add(BorderLayout.CENTER, htmlPanel);
  }

  public boolean back() {
    return htmlPanel.back();
  }
  public boolean forward() {
    return htmlPanel.forward();
  }

  public void setCurrentPageAsHome() {
    URL current = htmlPanel.currentURL();
    if (current != null) home = current;
    else UIUtil.warning(this, "HTMLFrame: No current page - home unchanged.");
  }

  public boolean displayURL(URL url) {
    if (url != null) return htmlPanel.displayURL(url);
    else {
      Debug.noteln("HTMLFrame: No URL given"); //don't warn user because of IP2
      return false;
    }
 }

  private boolean displayHome() {
    if (home != null) return htmlPanel.displayURL(home);
    else {
      UIUtil.warning(this, "No home page found");
      return false;
    }
  }
  public void actionPerformed(java.awt.event.ActionEvent event) {
    Object object = event.getSource();
    String command = ((AbstractButton)object).getActionCommand();
    //Debug.noteln("action object is",object);
    //Debug.noteln("HelpFrame: action command is",command);
    if (command == "close") this.setVisible(false);
    else if (command == "home") this.displayHome();
    else if (command == "setHome") this.setCurrentPageAsHome();
    else if (command == "back") this.back();
    else if (command == "forward") this.forward();
    else {
      String txt = ((AbstractButton)object).getText();
      if ((txt == "") || txt == null) txt = command;
      UIUtil.notImplemented(this, txt);
    }
  }
}
/*
 * Document all public methods
 */
