/****************************************************************************
 * An interface model to be used to fill an IFormPanel.
 *
 * @author Jussi Stader
 * @version 2.0
 * Updated: Thu Oct  5 09:27:41 2006
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui;

import ix.*;
import ix.util.Debug;
import ix.util.lisp.*;
import ix.iface.ui.util.*;

import java.util.*;
import java.lang.reflect.*;
//import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * An default model to be used to fill an IFormPanel.
 *
 */
public class GenericIFormModel extends AbstractIFormModel {

  public GenericIFormModel(Class objectClass) {
    super(objectClass);
  }
  public GenericIFormModel(EditableObject object) {
    super(object);
  }

  
  public void setFields() {
    if (baseObjectClass == null) {
      Debug.noteln("Cannot set fields for a null base object class.");
      return;
    }
    else {
      nameFields = this.deriveNameFields();
      displayFields = this.deriveDisplayFields();
      ArrayList allFields = new ArrayList(nameFields);
      allFields.addAll(displayFields);
      deriveNames(allFields);
      deriveClasses(allFields);
      //Debug.noteln("GenericIForm:", this.show());
    }
  }

  protected void deriveNames(List fields) {
    fieldNames.clear();
    if (fields.isEmpty()) return;
    else {
      for (Iterator i = fields.iterator(); i.hasNext(); ) {
	try {
	  String field = (String)i.next();
	  fieldNames.put(field, deriveName(field));
	}
	catch (Exception e) {}
      }
    }       
  }
  protected String deriveName(String field) {
    return UIUtil.toCapitalised(field);
  }


  protected void deriveClasses(List fields) {
    fieldClasses.clear();
    if (fields.isEmpty()) return;
    else {
      for (Iterator i = fields.iterator(); i.hasNext(); ) {
	try {
	  String field = (String)i.next();
	  Class type = deriveClass(field);
	  fieldClasses.put(field, type);
	}
	catch (Exception e) {}
      }
    }       
  }
  protected Class deriveClass(String field) {
    try {
      Field oField = stringToField(field);
      return oField.getType();
    }
    catch (Exception e) {
      Debug.note("Working on class " + getObjectClass().getName());
      Debug.noteln("Fields are: " + 
		   UIUtil.fieldsToNames(getObjectClass().getFields()));
      Debug.noteln(" Problem deriving class for field " + field);
      Debug.noteException(e);
      return null;
    }
  }


  protected List deriveNameFields() {
    //get the class to work with
    Class c = this.getObjectClass();
    if (c == null) {
      Debug.noteln("FormModel: base object class not known.");
      return null;
    }
    //get name fields
    List fields = new LListCollector();
    fields = (List)addIfField(fields, c, "name");
    fields = (List)addIfField(fields, c, "Name");
    if (fields.isEmpty()) {
      //get all class fields and search for sub-string name
      Field[] cFields = c.getFields();
      String fName;
      for (int i = 0; i<cFields.length; i++) {
	fName = cFields[i].getName().toUpperCase();
	if (fName.indexOf("NAME") != -1)
	  fields.add(cFields[i].getName());	
      }
    }
    fields = (List)addIfField(fields, c, "id");
    fields = (List)addIfField(fields, c, "Id");
    fields = (List)addIfField(fields, c, "ID");
    return fields;
  }

  protected List deriveDisplayFields() {
    //get the class to work with
    Class c = this.getObjectClass();
    if (c == null) {
      Debug.noteln("FormModel: base object class not known.");
      return null;
    }
    //get fields
    ArrayList fields = new ArrayList(Arrays.asList(c.getFields()));
    ArrayList dFields = new ArrayList();
    for (Iterator i = fields.iterator(); i.hasNext(); ) {
      Field field = (Field)i.next();
      if (useField(field)) 
	dFields.add(field.getName());
    }
    return dFields;
  }

  protected boolean useField(Field field) {
    int mod = field.getModifiers();
    //do not display protected, private, static, or name fields
    return (!Modifier.isStatic(mod) && 
	    !Modifier.isPrivate(mod) &&
	    !Modifier.isProtected(mod) && 
	    !nameFields.contains(field.getName()));
  }

  public String show() {
    return 
      getObjectClass().getName() + UIUtil.lineSeparator + 
      UIUtil.show(getNameNames()) + UIUtil.lineSeparator + 
      UIUtil.show(getDisplayNames());

  }

  public void setValue(String field, Object value) {
    //Debug.noteln("GenIFormModel: setting field " + field + " to", value);
    //Debug.noteln("GenIFormModel: setting value for field", field);
    super.setValue(field, value);
  } 
  public boolean setValue(EditableObject o, String field, Object value) {
    //Debug.noteln("GenIFormModel: setting oField " + field + " to", value);
    //Debug.noteln("GenIFormModel: setting value for field", field);
    return super.setValue(o, field, value);
  } 

}
