/****************************************************************************
 * Generic constraint that is part of the grammar. 
 *
 * @author Jussi Stader
 * @version 4.1
 * Updated: Wed Mar 14 13:52:36 2007
 * Copyright: (c) 2007, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.icore;

import java.util.*;

import ix.util.*;
import ix.util.lisp.*;
import ix.icore.domain.*;

/**
 * Generic constraint that is part of the grammar. Used in grammar's
 * genericConstraints map. Either generated automatically (no form,
 * has example) or explicitly (has form, may not have example).
 */
public class GenericConstraint extends AbstractAnnotatedObject {

    protected Symbol type;
    protected Symbol relation;
    protected String form;
    protected Object example;

  public GenericConstraint(Symbol type, Symbol relation) {
    if (type != null) {
      this.type = type;
      this.relation = relation;
    }
    else throw new NullPointerException("Trying to make GenericConstraint"
					+ " from null type");
  }
  public GenericConstraint(Constraint constraint) {
    if (constraint != null) {
      if (constraint.getType() != null) {
	setType(constraint.getType());
	setRelation(constraint.getRelation());
	setExample(constraint.getParameters());
      }
      else throw new NullPointerException("Trying to make GenericConstraint"
					  + " from illegal constraint"
					  + " (null type) " 
					  + constraint.toString());
    }
    else throw new NullPointerException("Trying to make GenericConstraint"
					+ " from null constraint");
  }

  public GenericConstraint(String type, String relation) {
    this(Symbol.intern(type), Symbol.intern(relation));
  }

  public Symbol getType() {return type;}
  public void setType(Symbol type) {this.type = type;}
  public Symbol getRelation() {return relation;}
  public void setRelation(Symbol relation) {this.relation = relation;}

  public String getForm() {return form;}
  public void setForm(String form) {this.form = form;}
  public Object getExample() {return example;}
  public void setExample(Object example) {this.example = example;}

  public boolean hasForm() {return (form != null) && (form != "");}
  public boolean hasExample() {return (example != null);}

  public String toString() {
      String sofar = type+" - "+relation+": "+form;
      if (example != null) sofar = sofar+" (e.g. "+example+")";
      return sofar;
  }


}


// Issues:
// * 
// * 
