/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Apr 23 15:00:16 2009 by Jeff Dalton
 * Copyright: (c) 2009, AIAI, University of Edinburgh
 */

package ix.iserve.ipc.sl;

import javax.servlet.http.HttpServletRequest;

import java.util.*;

import ix.test.xml.VirtualWorld;

import ix.util.*;

import static ix.iserve.ipc.sl.SLHttpHeader.*;

public class WorldTable {

    private Map<String,VirtualWorld> nameToWorld =
        new LinkedHashMap<String,VirtualWorld>();

    private Map<String,VirtualWorld> shardToWorldCache =
        new LinkedHashMap<String,VirtualWorld>();

    public WorldTable() {
    }

    public void add(VirtualWorld w) {
        if (w.getName() == null)
            throw new IllegalArgumentException
                ("Unnamed world " + w);
        if (w.getShard() == null)
            throw new IllegalArgumentException
                ("No user-agent speficied for world " + w.getName());
        nameToWorld.put(w.getName(), w);
    }

    public VirtualWorld worldNamed(String name) {
        return nameToWorld.get(name);
    }

    public VirtualWorld findWorld(HttpServletRequest req) {
        String shard = XSL_SHARD.getHeader(req);
        if (shard == null)
            return null;
        VirtualWorld world = shardToWorldCache.get(shard);
        if (world == null) {
            world = findMatchingWorld(shard);
            if (world == null)
                Debug.noteln("Could not find world for", shard);
            else
                shardToWorldCache.put(shard, world);
        }
        return world;
    }

    private VirtualWorld findMatchingWorld(String shard) {
        for (VirtualWorld w: nameToWorld.values())
            if (shard.matches(w.getShard()))
                return w;
        return null;
    }

}
