/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Mar 10 17:07:47 2009 by Jeff Dalton
 * Copyright: (c) 2007, 2009, AIAI, University of Edinburgh
 */

package ix.iserve.ipc.sl;

import java.util.*;

import ix.util.*;

/**
 * Second Life XML-RPC message.
 */
public class SLRpcMessage {

    protected String channel;
    protected int    intValue;
    protected String stringValue;

    public SLRpcMessage(String channel, int i, String s) {
	this.channel = channel;
	this.intValue = i;
	this.stringValue = s;
    }
    
    public String getChannel() {
	return channel;
    }
    
    public int getIntValue() {
	return intValue;
    }

    public String getStringValue() {
	return stringValue;
    }

    public String toString() {
	return "SLRpcMessage[" +
	    channel + ", " +
	    intValue + ", " +
	    stringValue +
	    "]";
    }

}
