/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Apr 23 15:01:02 2009 by Jeff Dalton
 * Copyright: (c) 2008 - 2009, AIAI, University of Edinburgh
 */

package ix.iserve.ipc.sl;

import javax.servlet.http.HttpServletRequest;

import java.net.HttpURLConnection;

import ix.util.http.HttpRequestException;

/**
 * Second-Life-related header names for HTTP requests sent from SL.
 */
public enum SLHttpHeader {

    USER_AGENT         ("User-Agent"),
    XSL_SHARD          ("X-SecondLife-Shard"),
    XSL_OBJECT_NAME    ("X-SecondLife-Object-Name"),
    XSL_OBJECT_KEY     ("X-SecondLife-Object-Key"),
    XSL_REGION         ("X-SecondLife-Region"),
    XSL_LOCAL_POSITION ("X-SecondLife-Local-Position"),
    XSL_LOCAL_ROTATION ("X-SecondLife-Local-Rotation"),
    XSL_LOCAL_VELOCITY ("X-SecondLife-Local-Velocity"),
    XSL_OWNER_NAME     ("X-SecondLife-Owner-Name"),
    XSL_OWNER_KEY      ("X-SecondLife-Owner-Key");

    private String text;

    SLHttpHeader(String text) {
        this.text = text;
    }

    public String text() {
        return text;
    }

    public String getHeader(HttpServletRequest req) {
        return req.getHeader(text);
    }

    public String requireHeader(HttpServletRequest req)
           throws HttpRequestException {
        String header = getHeader(req);
        if (header != null)
            return header;
        else
            throw new HttpRequestException
                (HttpURLConnection.HTTP_BAD_REQUEST,
                 "Missing required header " + text);
    }

}

