/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Jan  6 16:23:30 2009 by Jeff Dalton
 * Copyright: (c) 2009, AIAI, University of Edinburgh
 */

package ix.iserve.ipc;

import java.util.*;

import ix.test.LongToBytes;

import ix.util.*;

/**
 * Generates short ids that correspond to long ones.
 */
public class TinyIds {

    private long usedCount;

    private Map<String,String> longToTiny = new HashMap<String,String>();

    private Map<String,String> tinyToLong = new HashMap<String,String>();

    public TinyIds() {
        this(0);
    }

    public TinyIds(long seed) {
        this.usedCount = seed;
    }

    public synchronized long getSeed() {
        return usedCount;
    }

    public synchronized void setSeed(long uc) {
        this.usedCount = uc;
    }

    public synchronized String getTinyId(String longId) {
        String tinyId = longToTiny.get(longId);
        if (tinyId == null) {
            tinyId = LongToBytes.encode(++usedCount);
            longToTiny.put(longId, tinyId);
            tinyToLong.put(tinyId, longId);
        }
        return tinyId;
    }

    public synchronized String getLongId(String tinyId) {
        return tinyToLong.get(tinyId);
    }

    /**
     * Main program for testing.
     */
    public static void main(String[] argv) {
        TinyIds ti = new TinyIds(0);
	for (;;) {
	    String longId = Util.askLine("Long id:");
	    if (longId.equals("bye"))
		return;
            String tinyId = ti.getTinyId(longId);
            System.out.println(tinyId);
            System.out.println("Maps back to " + ti.getLongId(tinyId));
	}

    }

}
