/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Jul 16 18:34:16 2009 by Jeff Dalton
 * Copyright: (c) 2003, 2007 - 2009, AIAI, University of Edinburgh
 */

package ix.iserve.ipc;

import java.io.Serializable;
import java.util.Date;

import ix.iserve.ipc.IServeCommServer.Command;

import ix.icore.AbstractAnnotatedObject;

import ix.util.*;
import ix.util.lisp.*;

/**
 * Wrapper for messages sent via an {@link IServeCommStrategy}.
 */
public class MessageWrapper extends AbstractAnnotatedObject
                            implements Serializable {

    String from;
    String command;
    String to;
    String uuid;
    String password;
    Object contents;

    Date sendDate;		// typically only when command is send-to
    Integer sequenceNumber;	// Integer, rather than int, so it can be null

    String remoteHost;          // set on receiving side
    String remoteAddr;          // set on receiving side

    public MessageWrapper() {	// needed for XML translator etc
    }

    public static MessageWrapper makeSend(String from, String to,
                                          Object contents) {
        MessageWrapper w = new MessageWrapper();
        w.setFrom(from);
        w.setCommand(Command.SEND_TO);
        w.setTo(to);
        w.setContents(contents);
        return w;
    }

    public static MessageWrapper makeRegister(String from, String password) {
        MessageWrapper w = new MessageWrapper();
        w.setFrom(from);
        w.setCommand(Command.REGISTER);
        w.setPassword(password);
        return w;
    }

    public static MessageWrapper makeGetNextMessage(String from) {
        MessageWrapper w = new MessageWrapper();
        w.setFrom(from);
        w.setCommand(Command.GET_MESSAGE);
        return w;
    }

    public String getFrom() {
	return from;
    }
    public void setFrom(String from) {
	this.from = from;
    }

    public String getUUID() {
        return uuid;
    }
    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getUuid() {   // makes XML translator happy /\/
        return uuid;
    }

    public void setUuid(String uuid) {   // makes XML translator happy /\/
        this.uuid = uuid;
    }

    public String getCommand() {
	return command;
    }
    public void setCommand(String command) {
	this.command = command;
    }
    public void setCommand(Command command) {
        this.command = command.text();
    }

    public String getTo() {
	return to;
    }
    public void setTo(String to) {
	this.to = to;
    }

    public String getPassword() {
        return password;
    }
    public void setPassword(String pwd) {
        this.password = pwd;
    }

    public Object getContents() {
        return contents;
    }
    public void setContents(Object contents) {
        this.contents = contents;
    }

    public Date getSendDate() {
	return sendDate;
    }
    public void setSendDate(Date sendDate) {
	this.sendDate = sendDate;
    }

    public Integer getSequenceNumber() {
	return sequenceNumber;
    }
    public void setSequenceNumber(Integer s) {
	this.sequenceNumber = s;
    }
    public int getSeqNo() {
	return sequenceNumber.intValue();
    }
    public void setSeqNo(int i) {
	this.sequenceNumber = new Integer(i);
    }

    public String getRemoteHost() {
	return remoteHost;
    }
    public void setRemoteHost(String remoteHost) {
	this.remoteHost = remoteHost;
    }

    public String getRemoteAddr() {
	return remoteAddr;
    }
    public void setRemoteAddr(String remoteAddr) {
	this.remoteAddr = remoteAddr;
    }

}
