/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Sep 23 15:00:31 2009 by Jeff Dalton
 * Copyright: (c) 2003, 2007 - 2009, AIAI, University of Edinburgh
 */

package ix.iserve.ipc;

import java.util.*;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.*;

import ix.icore.IXAgent;
import ix.ip2.*;		// /\/
import ix.iface.util.*;
import ix.util.*;

/**
 * The user interface to an {@link IServeCommStrategy}.
 */
public class IServeCommTool {

    IServeCommStrategy strategy;

    ToolFrame frame;

    public IServeCommTool(IServeCommStrategy strategy, String frameTitle) {
	this.strategy = strategy;
	strategy.setTool(this);
	frame = new ToolFrame(frameTitle);
        strategy.initialCommToolTranscript();
    }

    public void setVisible(boolean v) {
	frame.setVisible(v);
    }

    public void register() {
        String agentName = strategy.getAgentName();
        String password =
            Util.showInputDialog(frame, "Enter a password for " + agentName,
                                 agentName);
        if (password == null) {
            frame.registerButton.setEnabled(true);
            return;		// user cancelled
        }
        try {
            strategy.register(password);
        }
        catch (Exception e) {
            Debug.displayException(e);
        }
    	// frame.registerButton.setEnabled(false);
    }

    void needToReregister() {
	Util.displayAndWait(frame, new String[] {
	    "This agent is unable to connect to the server needed",
	    "for inter-agent communications, probably because the server",
	    "has exited.  You will need to re-register when a server",
	    "is again available.  Some messages may have been lost."
	});
	frame.registerButton.setEnabled(true);
    }

    public void transcript(String line) {
	frame.appendLine(line);
    }

    /**
     * A simple GUI.
     */
    protected class ToolFrame extends TextAreaFrame {
	JButton registerButton;
	ToolFrame(String title) {
	    super(0, 0, title, new String[]{});
	    setEditable(false);
	    addListener(new ToolTListener());
	}
        @Override
	protected void finishFrame() {
	    // Doesn't make visible, unlike super method.
	    frame.pack();
	    frame.setSize(400, 200);
	    frame.validate();
	}
        @Override
        public void clearText() {
            setText("");
            strategy.initialCommToolTranscript();
        }
        @Override
	protected TFrame makeTFrame(String title, String[] buttons) {
	    return new ToolTFrame(title, buttons);
	}
	class ToolTFrame extends TFrame {
	    ToolTFrame(String title, String[] buttons) {
		super(title, buttons);
		contentPane.add(makeButtonPanel(), BorderLayout.SOUTH);
	    }
	    protected JPanel makeButtonPanel() {
		JPanel panel = new JPanel();
		panel.add(registerButton = makeButton("Register"));
		return panel;
	    }
	}
	class ToolTListener implements TListener {
	    ToolTListener() {}
	    public void buttonPressed(String command) {
		if (command.equals("Register"))
		    IServeCommTool.this.register();
		else
		    // Ignore commands that might be handled elsewhere
		    Debug.noteln("ToolTListener ignores", command);
	    }
	}
    }

    /**
     * A {@link ToolController} for an {@link IServeCommTool}.
     */
    public static class Controller extends ToolController {
	IServeCommStrategy strategy;
        String title;
	public Controller(IServeCommStrategy strategy,
                          String toolFrameTitle) {
	    super("I-Serve Communications");
	    this.strategy = strategy;
            this.title = toolFrameTitle;
	}
	protected Object createTool() {
	    return new IServeCommTool(strategy, title);
	}
    }

}
