/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Sep  8 17:04:21 2008 by Jeff Dalton
 * Copyright: (c) 2007, 2008, AIAI, University of Edinburgh
 */

package ix.iserve;

import ix.iserve.ipc.*;

import ix.util.IPC;
import ix.util.Parameters;

/**
 * A communication strategy that can be called "iserve".  This class
 * exists only for its name.  The name does not quite follow the usual
 * capitalisation rules, but this allows it to be called simply "iserve"
 * as a strategy when specifying {@link Parameters} to an agent, because
 * of the convention followed by the
 * {@link IPC#makeCommunicationStrategy(String)} method.
 *
 * <p>This class does not contain any significant code and instead
 * just extends another class that provides the actual strategy
 * implementation.</p>
 */
public class IserveCommunicationStrategy
       extends IServeCommStrategy {

    public IserveCommunicationStrategy() {
    }

}
