/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Dec 12 17:14:55 2008 by Jeff Dalton
 * Copyright: (c) 2006 - 2008, AIAI, University of Edinburgh
 */

package ix.iserve;

import java.util.*;

import ix.ip2.*;

import ix.util.*;
import ix.util.http.*;

/**
 * A process panel that also acts as an HTTP server.
 *
 * @see HttpServer
 */
public class IServe extends Ip2 {

    protected HttpServer server;

    protected Thread serverThread;

    public IServe() {
	super(true);		// true = stand-alone
        agentTypeName = "I-X Server";
	logoLine1 = "I-Serve";
	displayName = "I-Serve";
	showOptions = false;
    }

    public static void main(String[] argv) {
	Util.printGreeting("I-Serve");
	Debug.noteThreads = true;
	System.setProperty("java.net.preferIPv4Stack", "true");
	new IServe().mainStartup(argv);
    }

    public synchronized HttpServer getHttpServer() {
	return server;
    }

    /*
    public void startup() {
	Debug.noteln("Security manager =", System.getSecurityManager());
	System.setSecurityManager(new IServeSecurityManager());
	super.startup();
    }
    */

    public void startup() {

	int port = Parameters.getInt("http-server-port", 8080);

        server = makeHttpServer(port);
        configureServer(server);

        Debug.noteln("Starting", server);
	server.start();

// 	serverThread = new Thread("HTTP Server") {
// 	    public void run() {
// 		Debug.noteln(Thread.currentThread() + " is running.");
// 		server.setupServer();
// // 		server.addServlet(new IXHttpServer.HelloServlet("ok!"),
// // 				  "/ok/*");
// 		server.start();
// 	    }
// 	};
// 	serverThread.start();

	super.startup();

    }

    /**
     * Factory method called to create the http-server.
     */
    protected HttpServer makeHttpServer(int port) {
        return new HttpServer(port);
    }

    /**
     * Configures the http-server before it's started.
     */
    protected void configureServer(HttpServer server) {

	String docRoot = Parameters.getParameter("http-root-directory");
	if (docRoot != null)
	    server.parseDocRoot(docRoot, "files");

	server.setLogPath("logs", getAgentSymbolName());

    }

    public void addAboutInfo(List about) {
	about.add("");
	about.add("I-Serve is running an HTTP server on port " +
		  server.getServerPort());
	about.add("Its document root is " +
		  server.getDocRoot());
        about.add("URLs of the form");
        about.add("   " + server.getBaseUrl() + server.getDocPath() + "/");
        about.add("will be mapped to files in that directory.");
    }

    protected void addHandlers() {
	super.addHandlers();
	controller
	    .addActivityHandler(new AddServletHandler(this));
    }

}
