;;;; listof-gen-macros
;;; Author: Jeff Dalton <J.Dalton@ed.ac.uk>
;;; Created: August 2003
;;; Updated: Wed Feb 15 18:41:22 2006 by Jeff Dalton

(cl:in-package :listof)

(defmacro with-output-to-class-file ((&rest class-name-parts) &body body)
  `(let* ((*class-name* (concat-string ,@class-name-parts))
	  (*class-filename* (class-filename *class-name*)))
     (ensure-directories-exist *class-filename* :verbose t)
     (with-open-file (*output* *class-filename*
			       :direction :output
			       :if-exists :supersede)
       ,@body)))

;;; The information we need to generate the required class definitions.
;;;
;;; The :package is where we put the generated definitions.
;;; Normally, the :elt-class-package is the same, but it can
;;; be different, for instance if the class is provided by Java.
;;; We might put ListOfString in one of our packages even
;;; though String is in java.lang.
;;;
;;; Every listof struct field's value is either a string or
;;; a list of strings.

(defstruct listof
  (package "not a package")
  (elt-class "not an elt-class")
  (elt-class-package "not an elt-class-package")
  (impl-classes "not a list of impl-classes"))

;;; End
